const express = require('express');
const router = express.Router();
const officerController = require('../controllers/officerController');
const authMiddleware = require('../middleware/auth');

// Get assigned clients
router.get('/clients', authMiddleware, officerController.getAssignedClients);

// Get daily follow-up tasks
router.get('/daily-tasks', authMiddleware, officerController.getDailyTasks);

// Get client details
router.get('/clients/:clientId', authMiddleware, officerController.getClientDetails);

// Get loan details
router.get('/loan-details/:loanId', authMiddleware, officerController.getLoanDetails);

// Generate report
router.get('/report', authMiddleware, officerController.generateReport);
router.get('/generate-report', authMiddleware, officerController.generateReport);

// Get follow-up tasks
router.get('/follow-up-tasks', authMiddleware, officerController.getFollowUpTasks);

// Get notifications
router.get('/notifications', authMiddleware, officerController.getNotifications);

// Mark notification as read
router.put('/notifications/:notificationId/read', authMiddleware, officerController.markNotificationRead);

module.exports = router;