const express = require('express');
const router = express.Router();
const managerController = require('../controllers/managerController');
const authMiddleware = require('../middleware/auth');

// Dashboard stats
router.get('/dashboard', authMiddleware, managerController.getDashboardStats);

// Pending loans
router.get('/pending-loans', authMiddleware, managerController.getPendingLoans);

// Approve or reject loan
router.put('/loans/:loanId/status', authMiddleware, managerController.updateLoanStatus);

// Loan settings
router.get('/loan-settings', authMiddleware, managerController.getLoanSettings);
router.put('/loan-settings', authMiddleware, managerController.updateLoanSettings);

// System settings (processing fees, etc.)
router.get('/system-settings', authMiddleware, managerController.getSystemSettings);
router.put('/system-settings', authMiddleware, managerController.updateSystemSettings);

// User management
router.get('/users', authMiddleware, managerController.getAllUsers);
router.get('/users/:userId', authMiddleware, managerController.getUser);
router.post('/users', authMiddleware, managerController.createUser);
router.put('/users/:userId', authMiddleware, managerController.updateUser);
router.put('/users/:userId/reset-password', authMiddleware, managerController.resetPassword);
router.put('/users/:userId/status', authMiddleware, managerController.updateUserStatus);
router.delete('/users/:userId', authMiddleware, managerController.deleteUser);

// Client management
router.put('/clients/:clientId/assign', authMiddleware, managerController.assignClientToOfficer);

// Change own password
router.put('/change-password', authMiddleware, managerController.changePassword);

// Notifications
router.get('/notifications', authMiddleware, managerController.getNotifications);
router.delete('/notifications/clear-all', authMiddleware, managerController.clearAllNotifications);

// Get all officers
router.get('/officers', authMiddleware, managerController.getOfficers);

// Petty cash routes
router.get('/petty-cash', authMiddleware, managerController.getPettyCash);
router.post('/petty-cash', authMiddleware, managerController.addPettyCash);

// Financial oversight
router.get('/financial-oversight', authMiddleware, managerController.getFinancialOversight);

module.exports = router;