const express = require('express');
const router = express.Router();
const authMiddleware = require('../middleware/auth');
const upload = require('../middleware/upload');
const loanApplicationController = require('../controllers/loanApplicationController');

// All routes require authentication
router.use(authMiddleware);

// Create loan application with LC1 letter and optional collateral photo
router.post('/apply', 
    upload.fields([
        { name: 'lc1_letter', maxCount: 1 },
        { name: 'collateral_photo', maxCount: 1 }
    ]),
    loanApplicationController.createLoanApplication
);

// Get loan agreement for printing
router.get('/agreement/:loanId', loanApplicationController.getLoanAgreement);

// Upload guarantor photos
router.post('/guarantor/:guarantorId/photos',
    upload.fields([
        { name: 'photo', maxCount: 1 },
        { name: 'id_front', maxCount: 1 },
        { name: 'id_back', maxCount: 1 }
    ]),
    loanApplicationController.uploadGuarantorPhotos
);

// Upload/Update collateral for a loan
router.post('/loan/:loanId/collateral',
    upload.single('collateral_photo'),
    loanApplicationController.uploadCollateral
);

module.exports = router;
