const express = require('express');
const router = express.Router();
const financialReportsController = require('../controllers/financialReportsController');
const authenticate = require('../middleware/auth');

// All routes require authentication
router.use(authenticate);

// Financial statement routes
router.get('/income-statement', financialReportsController.generateIncomeStatement);
router.get('/balance-sheet', financialReportsController.generateBalanceSheet);
router.get('/cash-flow', financialReportsController.generateCashFlowStatement);
router.get('/loan-portfolio', financialReportsController.generateLoanPortfolioReport);
router.get('/collections', financialReportsController.generateCollectionsReport);
router.get('/disbursements', financialReportsController.generateDisbursementsReport);
router.get('/performance', financialReportsController.generatePerformanceSummary);

module.exports = router;
