const express = require('express');
const router = express.Router();
const authMiddleware = require('../middleware/auth');
const upload = require('../middleware/upload');
const enrollmentController = require('../controllers/enrollmentController');

// All routes require authentication
router.use(authMiddleware);

// Enroll new client (Officer or Manager)
router.post('/enroll', 
    upload.fields([
        { name: 'photo', maxCount: 1 },
        { name: 'id_front', maxCount: 1 },
        { name: 'id_back', maxCount: 1 },
        { name: 'lc1_letter', maxCount: 1 }
    ]),
    enrollmentController.enrollClient
);

// Get all clients
router.get('/clients', enrollmentController.getAllClients);

// Get client details
router.get('/clients/:clientId', enrollmentController.getClientDetails);

// Update client details (Manager only)
router.put('/clients/:clientId', enrollmentController.updateClientDetails);

// Get client loans
router.get('/clients/:clientId/loans', enrollmentController.getClientLoans);

// Assign client to officer (Manager only)
router.post('/assign', enrollmentController.assignClientToOfficer);

// Reset user password (Manager only)
router.post('/reset-password', enrollmentController.resetUserPassword);

module.exports = router;
