const express = require('express');
const router = express.Router();
const clientController = require('../controllers/clientController');
const authMiddleware = require('../middleware/auth');
const upload = require('../middleware/upload');

// Get loan overview
router.get('/loan-overview', authMiddleware, clientController.getLoanOverview);

// Get repayment progress
router.get('/repayment-progress', authMiddleware, clientController.getRepaymentProgress);

// Get portfolio growth
router.get('/portfolio-growth', authMiddleware, clientController.getPortfolioGrowth);

// Apply for a loan
router.post('/apply-loan', authMiddleware, clientController.applyForLoan);

// Pay application fee (Step 1)
router.post('/pay-application-fee', authMiddleware, clientController.payApplicationFee);

// Check application fee status
router.get('/application-fee-status', authMiddleware, clientController.checkApplicationFeeStatus);

// Check loan top-up eligibility
router.get('/topup-eligibility', authMiddleware, clientController.checkTopupEligibility);

// Request loan top-up
router.post('/loan-topup', authMiddleware, clientController.requestLoanTopUp);

// Get notifications
router.get('/notifications', authMiddleware, clientController.getNotifications);

// Mark notification as read
router.put('/notifications/:notificationId/read', authMiddleware, clientController.markNotificationRead);

// Clear all notifications
router.delete('/notifications/clear-all', authMiddleware, clientController.clearAllNotifications);

module.exports = router;