const express = require('express');
const router = express.Router();
const authController = require('../controllers/authController');
const authenticate = require('../middleware/auth');

// Login route
router.post('/login', authController.login);

// Registration route (if needed in the future)
router.post('/register', authController.register);

// Change password route (for logged-in users)
router.post('/change-password', authenticate, authController.changePassword);

module.exports = router;